% Copyright (c) 2013, Massachusetts Institute of Technology
% This program was presented in the book "Visual Psychophysics:
% From Laboratory to Theory" by Zhong-Lin Lu and Barbara Dosher.
% The book is available at http://mitpress.mit.edu/books/visual-psychophysics

%%% Program Weibull.m
function [tau, eta, thresholds, maxloglikelihood] = Weibull(PF)
  
data = PF;      % PF is the measured psychometric function. 
                % First row: contrasts; 
                % Second row: # of correct trials; 
                % Third row: # of incorrect trials.

guess = [0.02 3];   % tau eta
options = optimset('fminsearch');
[psy, minus_maxloglikelihood] = fminsearch('Weibullcostfunc', ...
      guess, options, data);
maxloglikelihood = - minus_maxloglikelihood;

%compute contrast thresholds at three performance levels
p = [0.65 0.75 0.85];
tau = psy(1);
eta = psy(2);
xi = 0.50;
lamda = 0.02;
thresholds  = ((-1)*log((1-lamda-p)./(1-lamda- ...
              xi))).^(1/eta)*tau; 
